/*
 * Decompiled with CFR 0.152.
 */
package ColorApplet;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ColorApplet
extends Applet {
    TextField textField_Hex = new TextField();
    TextField textField_RGB = new TextField();
    Scrollbar scrollbar_Red = new Scrollbar();
    Scrollbar scrollbar_Green = new Scrollbar();
    Scrollbar scrollbar_Blue = new Scrollbar();
    Label label_R = new Label();
    Label label_G = new Label();
    Label label_B = new Label();
    Label label_RGB = new Label();
    Label label_Hex = new Label();
    Canvas colorfield = new Canvas();
    boolean isStandalone = false;
    int r;
    int g;
    int b;
    private String[][] param_info = new String[][]{{"red", "decimal color value", "red value"}, {"green", "decimal color value", "green value"}, {"blue", "decimal color value", "blue value"}, {"rgb", "comma separated integer triplet", "red, green, blue color values"}, {"hex", "hexadecimal number", "classic HTML hex color code, without leading #"}};

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public String[][] getParameterInfo() {
        return this.param_info;
    }

    public String getAppletInfo() {
        return "Color Display, by Kelly Cochran";
    }

    public void init() {
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initComponents() throws Exception {
        String string;
        this.textField_Hex.setLocation(new Point(270, 250));
        this.textField_Hex.setVisible(true);
        this.textField_Hex.setSize(new Dimension(90, 20));
        this.textField_RGB.setLocation(new Point(110, 250));
        this.textField_RGB.setVisible(true);
        this.textField_RGB.setSize(new Dimension(90, 20));
        this.scrollbar_Red.setLocation(new Point(10, 30));
        this.scrollbar_Red.setVisible(true);
        this.scrollbar_Red.setMaximum(265);
        this.scrollbar_Red.setSize(new Dimension(10, 210));
        this.scrollbar_Green.setLocation(new Point(30, 30));
        this.scrollbar_Green.setVisible(true);
        this.scrollbar_Green.setMaximum(265);
        this.scrollbar_Green.setSize(new Dimension(10, 210));
        this.scrollbar_Blue.setLocation(new Point(50, 30));
        this.scrollbar_Blue.setVisible(true);
        this.scrollbar_Blue.setMaximum(265);
        this.scrollbar_Blue.setSize(new Dimension(10, 210));
        this.label_R.setText("R");
        this.label_R.setLocation(new Point(10, 10));
        this.label_R.setVisible(true);
        this.label_R.setSize(new Dimension(10, 10));
        this.label_G.setText("G");
        this.label_G.setLocation(new Point(30, 10));
        this.label_G.setVisible(true);
        this.label_G.setSize(new Dimension(10, 10));
        this.label_B.setText("B");
        this.label_B.setLocation(new Point(50, 10));
        this.label_B.setVisible(true);
        this.label_B.setSize(new Dimension(10, 10));
        this.label_RGB.setText("RGB: ");
        this.label_RGB.setLocation(new Point(70, 250));
        this.label_RGB.setVisible(true);
        this.label_RGB.setSize(new Dimension(40, 20));
        this.label_Hex.setText("HEX: #");
        this.label_Hex.setLocation(new Point(220, 250));
        this.label_Hex.setVisible(true);
        this.label_Hex.setSize(new Dimension(40, 20));
        this.colorfield.setLocation(new Point(70, 10));
        this.colorfield.setVisible(true);
        this.colorfield.setSize(new Dimension(310, 230));
        this.setLocation(new Point(0, 0));
        this.setBackground(SystemColor.scrollbar);
        this.setLayout(null);
        this.setSize(new Dimension(400, 300));
        this.add(this.textField_Hex);
        this.add(this.textField_RGB);
        this.add(this.scrollbar_Red);
        this.add(this.scrollbar_Green);
        this.add(this.scrollbar_Blue);
        this.add(this.label_R);
        this.add(this.label_G);
        this.add(this.label_B);
        this.add(this.label_Hex);
        this.add(this.label_RGB);
        this.add(this.colorfield);
        this.scrollbar_Red.addAdjustmentListener(new 1());
        this.scrollbar_Green.addAdjustmentListener(new 2());
        this.scrollbar_Blue.addAdjustmentListener(new 3());
        this.textField_RGB.addActionListener(new 4());
        this.textField_Hex.addActionListener(new 5());
        this.r = Integer.parseInt(this.getParameter("red", "0"));
        this.g = Integer.parseInt(this.getParameter("green", "0"));
        this.b = Integer.parseInt(this.getParameter("blue", "0"));
        String string2 = this.getParameter("rgb", null);
        if (string2 != null) {
            this.parseRGBString(string2);
        }
        if ((string = this.getParameter("hex", null)) != null) {
            this.parseHexString(string);
        }
    }

    public void paint(Graphics graphics) {
        this.scrollbar_Red.setValue(this.r);
        this.scrollbar_Green.setValue(this.g);
        this.scrollbar_Blue.setValue(this.b);
        ((TextComponent)this.textField_RGB).setText(String.valueOf(this.r) + "," + this.g + "," + this.b);
        ((TextComponent)this.textField_Hex).setText(new String(String.valueOf(this.r < 16 ? "0" : "") + Integer.toHexString(this.r) + (this.g < 16 ? "0" : "") + Integer.toHexString(this.g) + (this.b < 16 ? "0" : "") + Integer.toHexString(this.b)).toUpperCase());
        this.colorfield.setBackground(new Color(this.r, this.g, this.b));
    }

    public void scrollbar_RedAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.r = this.scrollbar_Red.getValue();
        this.repaint();
    }

    public void scrollbar_GreenAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.g = this.scrollbar_Green.getValue();
        this.repaint();
    }

    public void scrollbar_BlueAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.b = this.scrollbar_Blue.getValue();
        this.repaint();
    }

    public void textField_RGBactionPerformed(ActionEvent actionEvent) {
        String string = ((TextField)actionEvent.getSource()).getText();
        if (string == null) {
            return;
        }
        if (this.parseRGBString(string)) {
            this.repaint();
        }
    }

    public void textField_HexactionPerformed(ActionEvent actionEvent) {
        String string = ((TextField)actionEvent.getSource()).getText();
        if (string == null) {
            return;
        }
        if (this.parseHexString(string)) {
            this.repaint();
        }
    }

    public boolean parseRGBString(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.r = Integer.parseInt(stringTokenizer.nextToken());
            this.g = Integer.parseInt(stringTokenizer.nextToken());
            this.b = Integer.parseInt(stringTokenizer.nextToken());
            if (this.r < 0) {
                this.r = 0;
            }
            if (this.r > 255) {
                this.r = 255;
            }
            if (this.g < 0) {
                this.g = 0;
            }
            if (this.g > 255) {
                this.g = 255;
            }
            if (this.b < 0) {
                this.b = 0;
            }
            if (this.b > 255) {
                this.b = 255;
            }
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean parseHexString(String string) {
        try {
            long l = Integer.parseInt(string, 16);
            this.r = (int)((l & 0xFF0000L) >> 16);
            this.g = (int)((l & 0xFF00L) >> 8);
            this.b = (int)(l & 0xFFL);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private final class 1
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ColorApplet.this.scrollbar_RedAdjustmentValueChanged(adjustmentEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ColorApplet.this.scrollbar_GreenAdjustmentValueChanged(adjustmentEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ColorApplet.this.scrollbar_BlueAdjustmentValueChanged(adjustmentEvent);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ColorApplet.this.textField_RGBactionPerformed(actionEvent);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ColorApplet.this.textField_HexactionPerformed(actionEvent);
        }

        /* synthetic */ 5() {
        }
    }
}

